local TaskManager = require "TaskManager"
local missionutil = require "missionutil"


local function makeIntroTask(doneFn)
	
local info = {
        name = _("Task 01"),
		paragraphs = {
			{ text = "Start the mission..." },
			{ type = "HINT", text = _("Its best to look at the existing mission scripts to learn how everythin works.") },
		},
    }
	
	local function fn(taskManager, task)
		task.addMedal("MEDAL")
		
		task.setCompleted()

		doneFn(taskManager)
	end
	
	info.options = { { _("Start!"), fn } }
	info.optionsRightAlign = true

	local task = missionutil.makeTask(info)
	task.setProgressNone()

	return task
end

local function makeMissionComplete(label)

	local info = {
		title = _("Mission completed!"), 
		name = _("Mission completed!"),
		description = _("It's finally done!")
	}

	local function fn(taskManager, task)
		missionutil.completeAllTasks(taskManager)
	end

	local task = missionutil.makeMissionCompleteTask(info, fn)
	
	return task
end

function data()
	
	local tm = TaskManager.new()
	
	tm:register("messageIntro", makeIntroTask, missionutil.addTask("missionComplete"))
	tm:register("missionComplete", makeMissionComplete)
	
	local mission = missionutil.makeMissionInterface(tm)

	mission.onInit(function ()
		tm:add("messageIntro")
	end)

	return mission
end
